// PhBTexturedSurface.H: PhBTexturedSurface nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBTexturedSurface_H_
#define _PhBTexturedSurface_H_

#include "xrml.H"
#include "PhBSurface.H"
#include "PhBTexture.H"
#include "TextureTransform.H"
#include "PhBTextureProjection.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBTexturedSurfaceTypeId 	"PhBTexturedSurface"
extern bool IsPhBTexturedSurface(SFNode*);

class PhBTexturedSurface: public virtual SFNode, public PhBSurface {
private:
  //
  void clone_here(const PhBTexturedSurface&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    surfaces_updated = 0x2,
    textureTransform_updated = 0x4,
    textureProjection_updated = 0x8 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  MFNode 	_surfaces;
  void 	synchronize_surfaces(void);
  SFNode* 	_textureTransform;
  void 	synchronize_textureTransform(void);
  SFNode* 	_textureProjection;
  void 	synchronize_textureProjection(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBTexturedSurface();
  PhBTexturedSurface(const PhBTexturedSurface&);
  PhBTexturedSurface& operator=(const PhBTexturedSurface&);
  virtual ~PhBTexturedSurface();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhBTexture*      	texture;
  array<PhBSurface*> 	surfaces;
  TextureTransform* 	textureTransform;
  PhBTextureProjection* 	textureProjection;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_surfaces(const MFNode&);
  void             	set_textureTransform(SFNode*);
  void             	set_textureProjection(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_surfaces(const MFNode&);
  bool             	assign_textureTransform(SFNode*);
  bool             	assign_textureProjection(SFNode*);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	surfaces_is_updated(void) { return (status & surfaces_updated); }
  inline void      	surfaces_clear_update(void) { status &= ~surfaces_updated; }
  inline bool      	textureTransform_is_updated(void) { return (status & textureTransform_updated); }
  inline void      	textureTransform_clear_update(void) { status &= ~textureTransform_updated; }
  inline bool      	textureProjection_is_updated(void) { return (status & textureProjection_updated); }
  inline void      	textureProjection_clear_update(void) { status &= ~textureProjection_updated; }
  
  // utility members
  bool isLightSource(void);

  bool isScatterer(void);

  bool isTextured(void)
  {
    return true;
  }

  Spectrum evaluateEDF(const Vec3& point,
		       const Vec3& texco, const Vec3& texco3d,
		       const Vec3& direction,
		       const Spectrum& specWeight,
		       int range,
		       float *pdf);
  
  Vec3 sampleEDF(const Vec3& point,
		 const Vec3& texco, const Vec3& texco3d,
		 const Spectrum& specWeight,
		 float xi1, float xi2,
		 int range,
		 Spectrum *value, float *pdf);
  
  Spectrum emittance(const Vec3& point,
		     const Vec3& texco, const Vec3& texco3d,
		     int range);
  
  Spectrum evaluateBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
			const Vec3& inDir,
			const Vec3& outDir,
			const Spectrum& inSpec,
			const complex& indexIn,
			const complex& indexOut,
			int modes, 
			float *pdf);

  Vec3 sampleBSDF(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const Spectrum& inSpec,
		  const complex& indexIn,
		  const complex& indexOut,
		  float xi1, float xi2, 
		  int modes,
		  Spectrum *value, float *pdf);

  Spectrum albedo(const Vec3& point, const Vec3& texco, const Vec3& texco3d,
		  const Vec3& inDir,
		  const complex& indexIn,
		  const complex& indexOut,
		  int modes);


protected:
  int nrcomponents;  // minimum of nr of surfaces and nr of texture channels

  Vec3 get_texcoord(const Vec3& point, const Vec3& texco);

  float *W;          // temporary weights array used for sampling,
                     // calculated with bsdf|edf_sampling_weights()
  float bsdf_sampling_weights(const Vec3& point,
			      const Vec3& texco, const Vec3& texco3d,
			      const Vec3& inDir,
			      const Spectrum& inSpec,
			      const complex& indexIn,
			      const complex& indexOut,
			      const int modes,
			      const float *texture_val);
  float edf_sampling_weights(const Vec3& point,
			      const Vec3& texco, const Vec3& texco3d,
			      const Spectrum& specWeight,
			      const int range,
			      const float *texture_val);

  inline void util_init(void) { W = 0; nrcomponents = 0; }
  inline void util_clone(const PhBTexturedSurface& src) { W = 0; nrcomponents = 0; }
  inline void util_destruct(void) { if (W) delete[] W; }
};

// end of utility members
} // namespace xrml
#endif /*_PhBTexturedSurface_H_*/
