// PhBVolumeDistortion.H: PhBVolumeDistortion nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PhBVolumeDistortion_H_
#define _PhBVolumeDistortion_H_

#include "xrml.H"
#include "PhBDistortion.H"
#include "PhB3DTexture.H"
#include "Transform.H"

// utility includes
// end of utility includes

namespace xrml {
#define PhBVolumeDistortionTypeId 	"PhBVolumeDistortion"
extern bool IsPhBVolumeDistortion(SFNode*);

class PhBVolumeDistortion: public virtual SFNode, public PhBDistortion {
private:
  //
  void clone_here(const PhBVolumeDistortion&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    texture_updated = 0x1,
    transform_updated = 0x2 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  SFNode* 	_transform;
  void 	synchronize_transform(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PhBVolumeDistortion();
  PhBVolumeDistortion(const PhBVolumeDistortion&);
  PhBVolumeDistortion& operator=(const PhBVolumeDistortion&);
  virtual ~PhBVolumeDistortion();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  PhB3DTexture*    	texture;
  Transform*       	transform;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_texture(SFNode*);
  void             	set_transform(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_texture(SFNode*);
  bool             	assign_transform(SFNode*);
  
  // update status
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	transform_is_updated(void) { return (status & transform_updated); }
  inline void      	transform_clear_update(void) { status &= ~transform_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PhBVolumeDistortion& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PhBVolumeDistortion_H_*/
