/* ReadImage.H : reads image files (PPM, TIFF, PIC) into memory */

#ifndef _ReadImage_H_
#define _ReadImage_H_

#include "xrml.H"
#include "world.H"

namespace xrml {

class Image {

public:

  float *map;
  long channels;
  long width, height;

  Image() {
    map = NULL;
    channels = 0;
    width = 0;
    height = 0;
  }
  Image(MFString url, class world *world) { load(url, world); }
  ~Image() { unload(); }
  Image& operator=(const Image& src);

  void load(MFString url, class world *world);
  void unload() { if (map) delete map; }
};

}

#endif /*_ReadImage_H_*/
