// mipmap.H: A mipmap data structure

#ifndef _MIPMAP_H_
#define _MIPMAP_H_

#include "vector.H"

namespace xrml {

// A simple image, indexed by u,v. [0,1[ x [0,1[ covers the image,
// repeating is used for other u,v
class SimpleImage
{
public:
  float *image;
  
  long width, height;
  int channels;

  SimpleImage() { image = NULL; width = 0; height = 0; }
  SimpleImage(float *pimage, long pw, long ph, int pchannels);
  void ReleaseImage();
  void Value(double u, double v, float *result);
protected:
  long index(long i, long j, int ch) { return ((j*width + i) * channels + ch); }
  float *getpixel(long i, long j);
  
  friend class MipMap;
};

// A mipmap class, indexed by u,v as for simple images but
// a continuous level of detail lod can be given between
// 0 and 1, with 0 being the average of the whole image
// and 1 being the full resolution.
// The level in the mipmap ~= lod*(log_2(width)+1)
// Only (2^N) pixels large, square images are supported
// Trilinear filtering is used
class MipMap
{
public:
  int levels, channels;
  SimpleImage *maps;
  
  MipMap(const SimpleImage &baseImage);
  ~MipMap();
  
  void Value(double u, double v, float lod, float *result);
  void FilteredValue(const Vec2& uv, const Vec2& da, 
		     const Vec2& db, float *result);
};

}  // namespace xrml

#endif // _MIPMAP_H_
