// comparable string

#ifndef _XRML_CMP_STRING_H_
#define _XRML_CMP_STRING_H_

#include <string.h>
#include "memory.H"

namespace xrml {

class comparable_string: public PooledObj {
  char *s;
public:
  inline comparable_string(char *t =0) { s = t; }
  inline operator char*() const	       { return s; }
  inline bool operator==(const char* t) const { return ((!s && !t) || (s && t && strcmp(s,t)==0)); }
  inline bool operator==(const comparable_string& t) const { return ((!s && !t.s) || (s && t.s && strcmp(s,t.s)==0)); }
  friend ostream& operator<<(ostream& s, const comparable_string& str) { return s << str.s; }
};

} // namespace xrml

#endif /* _XRML_CMP_STRING_H_ */
