/* eventManager.H */

#ifndef _XRML_EVENT_MANAGER_H_
#define _XRML_EVENT_MANAGER_H_

#include "List.H"

namespace xrml {

typedef class list<const class interfaceMember*> event_list;

class EventManager {
public:
  PoolDecl(EventManager, "EventManager")

protected:
  class world *world;		// world owning the event manager

  event_list *nextEvent, *lastEvent;	// head and tail of event queue
  int nrEvents;				// nr of queued events
  bool dispatch_immediately;		// if true, post() dispatches new events
                                        // immediately, if false, post() queues.

  void queue(const class interfaceMember *event); // append to tail of event queue
  void dispatch(const class interfaceMember *event) const;
  event_list* take_event(void);		// removes and returns head of event queue

public:
  inline EventManager()
  {
    nextEvent = lastEvent = 0;
    nrEvents = 0;
    dispatch_immediately = false;
    world = 0;
  }

  void init(class world *world);

  // queues a dispatches according to 'dispatch_immediately' flag.
  void post(const class SFNode *srcnode, const class interfaceMember *event);

  // Returns nr of queued events.
  int nrQueuedEvents(void) const;

  // Dispatches all queued events
  void dispatch_all(void);
};

} // namespace xrml


#endif /* _XRML_EVENT_MANAGER_H_ */
