/* ExternProto.H: EXTERNPROTO nodes, much similar to PROTO's */

#ifndef _XRML_EXTERNPROTO_H_
#define _XRML_EXTERNPROTO_H_

#include "Proto.H"

namespace xrml {

class ExternProto: public Proto {
protected:
  MFString url;

  void resolve(void);

  void clone_here(const ExternProto& src);
  void destruct(void);

public:
  PoolDecl(ExternProto, "ExternProto")

  ExternProto(SFNode *master);
  ExternProto(const ExternProto&);
  ExternProto& operator=(const ExternProto&);
  ~ExternProto();

  void fetch(const MFString* urls);

  SFNode *instantiate(Proto *master =0);
};

extern bool IsUnresolvedExternProto(SFNode *node);
extern bool IsExternProto(SFNode *node);

} // namespace xrml

#endif /*_XRML_EXTERNPROTO_H_*/
