/* SFImage.C */

#include "xrml.H"
#include "file.H"

namespace xrml {

PoolImpl(SFImage)
PoolImpl(MFImage)

void SFImage::construct(int w, int h, int n, unsigned int *pix)
{
  width = w; height = h; num_components = n; 
  int num_pixels = width * height;
  if (num_pixels > 0) {
    pixels = new unsigned int[num_pixels];
    if (pix) 
      for (int i=0; i<num_pixels; i++) pixels[i] = pix[i];
  } else
    pixels = 0;
}

void SFImage::destruct(void)
{
  delete[] pixels;
}

SFImage::SFImage(unsigned int w, unsigned int h, unsigned int n, unsigned int *pix)
{
  construct(w, h, n, pix);
}

SFImage::SFImage(const SFImage& src)
{
  construct(src.width, src.height, src.num_components, src.pixels);
}

SFImage& SFImage::operator=(const SFImage& src)
{
  if (this != &src) {
    destruct();
    construct(src.width, src.height, src.num_components, src.pixels);
  }
  return *this;
}

SFImage::~SFImage()
{
  destruct(); 
}

ostream& operator<<(ostream& s, SFImage& im)
{
  s << im.width << ' ' << im.height << ' ' << im.num_components;
  for (int i=0; i<im.width * im.height; i++)
    s << ' ' << hex << im.pixels[i];
  return s;
}

} // namespace xrml
