/* error.h: afdrukken van waarschuwingen, fouten, fatale fouten  */

#ifndef _XRML__ERROR_H_
#define _XRML__ERROR_H_

namespace xrml {

/* routines for communication of informational, warning, error and fatal error
 * messages to the user of the library. The routines to be specified
 * have one char * parameter: the message being passed. */
typedef void (*MSG_CALLBACK_FUNC)(char *);

/* default message printing routine */
extern void printmsg(char *msg);

/* max. length of a message communicated by the XRML library. */
#define MAX_MESSAGE_LENGTH 1000

/* default informational message callback function is NULL: they are ignored. */
extern MSG_CALLBACK_FUNC SetInfoCallback(MSG_CALLBACK_FUNC func);

/* default warning and error message callback function print to stderr. */
extern MSG_CALLBACK_FUNC SetWarningCallback(MSG_CALLBACK_FUNC func);
extern MSG_CALLBACK_FUNC SetErrorCallback(MSG_CALLBACK_FUNC func);

/* default fatal error callback function prints the message and exits
 * the program with -1 return code. */
extern MSG_CALLBACK_FUNC SetFatalCallback(MSG_CALLBACK_FUNC func);

/* ------------------------------------------------------------------ */

#ifndef NULL
#define NULL (char *)0
#endif /*NULL*/

#ifndef FALSE
#define FALSE 0
#endif /*FALSE*/

#ifndef TRUE
#define TRUE 1
#endif /*TRUE*/

extern void Info(char *routine, char *text, ...);
extern void Error(char *routine, char *text, ...);
extern void Warning(char *routine, char *text, ...);
extern void Fatal(int errcode, char *routine, char *text, ...);

} // namespace xrml

#endif /*_XRML__ERROR_H_*/
