// exporter.H: XRML exporter base class

#ifndef _XRML_EXPORTER_H_
#define _XRML_EXPORTER_H_

#include "xrml.H"
#include "xrmlP.H"
#include "file.H"

namespace xrml {

// Scene graph Export filter base class. Exporter objects
// passed to xrml::world::save() inherit from this class.
class exporter {
public:
  // file handle to which to write the output
  file *fh;

  // Called by xrml::world::save() after opening the output
  // file handle (if appropriate) and before calling
  // save() below.
  virtual void init(class file* file_handle)
  {
    fh = file_handle;
  }

  exporter(class file* file_handle =0)
  {
    init(file_handle);
  }

  // This member functions gets called by xrml::world::save()
  // and shall do the actual exporting.
  virtual void save(class world* world)
  { 
    Warning("xrml::exporter::save(world)", "not yet implemented"); 
  }
};

} // namespace xrml

#endif /*_XRML_EXPORTER_H_*/
