// importer.H: XRML scene graph importer base class

#ifndef _XRML_IMPORTER_H_
#define _XRML_IMPORTER_H_

#include "xrml.H"
#include "xrmlP.H"
#include "file.H"

namespace xrml {

class importer {
public:
  // This member function checks whether or not the importer class is
  // appropriate for parsing the specified file. If not, it returns
  // a null pointer. If appropriate, this functions returns a new
  // instance of the importer class.
  // In case file_handle is null, this member just returns a new
  // instance of the importer class.
  virtual importer* instantiate(class file* file_handle =0)
  {
    Error("importer::instantiate", "not yet implemented");
    return 0;
  }

  // After instantiating an importer for a file, this member functions is
  // called from world->parse(). It parses the file desribed by the file
  // handle world->file (same handle as used for the instantiate() call).
  // The resulting scene graph is APPENDED to the following members of
  // the world object:
  // . sceneGraph (MFNode*)
  // . namedNodes (namedNodeTable) : table of named nodes (if any)
  // . protos (protoTable) : table of PROTO and EXTERNPROTO defined, if any.
  // After parsing, strpool shall point to a pool of strings read from 
  // the file (if applicable).
  virtual bool parse(class world* world, char **strpool)
  {
    Error("importer::parse", "not yet implemented");
    return false;
  }
};

} // namespace xrml

#endif /*_XRML_IMPORTER_H_*/
