// link.C: node interface member links

#include "nodeInterface.H"
#include "Proto.H"
#include "file.H"

namespace xrml {

PoolImpl(link)

void link::init(class SFNode* refnode, class interfaceMember* refifm, class SFNode* srcnode, class interfaceMember* srcifm)
{
  interfaceMemberRef::init(refnode, refifm);

  // Add a forward link to the linked interface member.
  refifm->forward_links = refifm->forward_links->prepend(interfaceMemberRef(srcnode, srcifm));
}

void link::instantiate(class Proto* master, class SFNode* srcnode, class interfaceMember* srcifm)
{
  // Replace 'refnode', pointing to innermost enclosing
  // PROTO, by 'master', a new enclosing PROTO of the same type.
  refnode = master;

  // Add a new forward link to the linked interface member.
  class interfaceMember *refifm = ref();
  refifm->forward_links = refifm->forward_links->prepend(interfaceMemberRef(srcnode, srcifm));
}

} // namespace xrml

