// PhBRenderer.C: physically based appearance node handlers

#include "renderer.H"

#include "PhBAppearance.H"
#include "PhBAtmosphere.H"
#include "PhBTexturedBackground.H"
#include "PhBProceduralBackground.H"
#include "PhBHomogeneousBackground.H"
#include "PhBBackgroundLight.H"
#include "PhBMonitorCalibration.H"

namespace xrml {

void renderer::begin_PhBAppearance(PhBAppearance *node)
{
  ignore(node);
}

void renderer::end_PhBAppearance(PhBAppearance */*node*/)
{
  // silently ignore
}

void renderer::phbAtmosphere(PhBAtmosphere *node)
{
  ignore(node);
}

void renderer::phbBackground(PhBBackground *node)
{
  ignore(node);
}

void renderer::phbTexturedBackground(PhBTexturedBackground *node)
{
  phbBackground(node);
}

void renderer::phbProceduralBackground(PhBProceduralBackground *node)
{
  phbBackground(node);
}

void renderer::phbHomogeneousBackground(PhBHomogeneousBackground *node)
{
  phbBackground(node);
}

void renderer::phbBackgroundLight(PhBBackgroundLight *node)
{
  phbBackground(node);
}

void renderer::phbMonitorCalibration(PhBMonitorCalibration* node)
{
  ignore(node);
}

} // namespace xrml
