// route.C: event routes

#include <assert.h>
#include "nodeInterface.H"
#include "List.H"
#include "error.H"
#include "file.H"
#include "route.H"

namespace xrml {

void routing_table::clone(class routing_table *dst) const
{
  dst->routes = routes->clone();
}

void routing_table::instantiate(class Proto* master)
{
  for (route_list *r=routes; r; r=r->next) {
    class route* route = (class route*)(*r);
    route->instantiate(master);
  }
}

void routing_table::add(class SFNode *dstnode, class interfaceMember *dstifm)
{
  route r(dstnode, dstifm);
  if (!routes || !routes->find(r)) {
    route_list *rl = new route_list(r);
    routes = routes ? routes->prepend(r) : rl;
  }
}

void routing_table::dispatch(const fieldValue& value) const
{
  for (route_list *r=routes; r; r=r->next) {
    class route* route = (class route*)(*r);
    route->ref()->process(route->refnode, value);
  }
}

ostream& routing_table::print(ostream& s) 
{
  if (routes) {
    s << " ROUTEd to ";
    for (route_list *r=routes; r; r=r->next) {
      class route* route = (class route*)(*r);
      s << (r!=routes ? ", " : "") << (*route);
    }
  }
  return s;
}

PoolImpl(routing_table)
PoolImpl(route)

} // namespace xrml
