/* xrmlP.H: XRML parser/execution engine/renderer private stuff */

#ifndef _XRMLP_H_
#define _XRMLP_H_

#include <assert.h>

#include "xrml.H"
#include "world.H"
#include "fieldValue.H"
#include "nodeInterface.H"
#include "Proto.H"

namespace xrml {
  // Current world/filename and linenr being parsed. These global variables are
  // used in two places:
  // - SFNode constructor: for filling in where and when a node is created
  // - error messages: print automatically where an error occurs or where
  // a warning is generated.
  extern class world* current_world;
  extern int current_linenr;
  extern char *current_filename;

  // The VRML specs state certain rules for initially binding
  // ("making current") bindable nodes (e.g. Viewpoint) during
  // parsing. The following flag controls such binding.
  // If this flags is set to 'true' and a newly created
  // bindable node happens to be the first of its kind in the
  // current world, it will be bound (see 
  // bindable_stacks::register_bindable in bindables.C).
  extern bool init_bind_bindables;
}

#endif /*_XRMLP_H_*/
