/* Appearance.C: Appearance nodes (public source) */

#include "Appearance.H"
#include "renderer.H"

namespace xrml {

void Appearance::render(void)
{
  // does nothing
}

void Appearance::begin_render(void)
{
  world->renderer->begin_Appearance(this);
  if (textureTransform) textureTransform->begin_render();
  if (texture) texture->begin_render();
  if (material) material->begin_render();
}

void Appearance::end_render(void)
{
  if (material) material->end_render();
  if (texture) texture->end_render();
  if (textureTransform) textureTransform->end_render();
  world->renderer->end_Appearance(this);
}

}  // namespace xrml
