// Appearance.H: Appearance nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Appearance_H_
#define _Appearance_H_

#include "xrml.H"
#include "AppearanceBase.H"
#include "Material.H"
#include "Texture.H"
#include "TextureTransform.H"

// utility includes
// end of utility includes

namespace xrml {
#define AppearanceTypeId 	"Appearance"
extern bool IsAppearance(SFNode*);

class Appearance: public virtual SFNode, public AppearanceBase {
private:
  //
  void clone_here(const Appearance&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    material_updated = 0x1,
    texture_updated = 0x2,
    textureTransform_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_material;
  void 	synchronize_material(void);
  SFNode* 	_texture;
  void 	synchronize_texture(void);
  SFNode* 	_textureTransform;
  void 	synchronize_textureTransform(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Appearance();
  Appearance(const Appearance&);
  Appearance& operator=(const Appearance&);
  virtual ~Appearance();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  Material*        	material;
  Texture*         	texture;
  TextureTransform* 	textureTransform;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_material(SFNode*);
  void             	set_texture(SFNode*);
  void             	set_textureTransform(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_material(SFNode*);
  bool             	assign_texture(SFNode*);
  bool             	assign_textureTransform(SFNode*);
  
  // update status
  inline bool      	material_is_updated(void) { return (status & material_updated); }
  inline void      	material_clear_update(void) { status &= ~material_updated; }
  inline bool      	texture_is_updated(void) { return (status & texture_updated); }
  inline void      	texture_clear_update(void) { status &= ~texture_updated; }
  inline bool      	textureTransform_is_updated(void) { return (status & textureTransform_updated); }
  inline void      	textureTransform_clear_update(void) { status &= ~textureTransform_updated; }
  
  // utility members
  virtual void    	begin_render(void);
  virtual void    	end_render(void);

protected:
  inline void util_init(void) { }
  inline void util_clone(const Appearance& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Appearance_H_*/
