// AudioClip.H: AudioClip nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _AudioClip_H_
#define _AudioClip_H_

#include "xrml.H"
#include "TimeDependent.H"
#include "SoundSource.H"

// utility includes
// end of utility includes

namespace xrml {
#define AudioClipTypeId 	"AudioClip"
extern bool IsAudioClip(SFNode*);

class AudioClip: public virtual SFNode, public TimeDependent, public SoundSource {
private:
  //
  void clone_here(const AudioClip&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    description_updated = 0x1,
    loop_updated = 0x2,
    pitch_updated = 0x4,
    startTime_updated = 0x8,
    stopTime_updated = 0x10,
    url_updated = 0x20,
    duration_changed_updated = 0x40,
    isActive_updated = 0x80 
  };
  
protected:
  // raw eventOut posting:
  void post_duration_changed(void);
  void post_isActive(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  AudioClip();
  AudioClip(const AudioClip&);
  AudioClip& operator=(const AudioClip&);
  virtual ~AudioClip();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFString         	description;
  //  SFBool           	loop;
  SFFloat          	pitch;
  //  SFTime           	startTime;
  //  SFTime           	stopTime;
  MFString         	url;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_description(const SFString&);
  void             	set_loop(const SFBool&);
  void             	set_pitch(const SFFloat&);
  void             	set_startTime(const SFTime&);
  void             	set_stopTime(const SFTime&);
  void             	set_url(const MFString&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_description(const SFString&);
  bool             	assign_loop(const SFBool&);
  bool             	assign_pitch(const SFFloat&);
  bool             	assign_startTime(const SFTime&);
  bool             	assign_stopTime(const SFTime&);
  bool             	assign_url(const MFString&);
  
  // eventOuts:
  SFTime            	duration_changed;
  void             	post_duration_changed(const SFTime& val);
  //  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  
  // update status
  inline bool      	description_is_updated(void) { return (status & description_updated); }
  inline void      	description_clear_update(void) { status &= ~description_updated; }
  inline bool      	loop_is_updated(void) { return (status & loop_updated); }
  inline void      	loop_clear_update(void) { status &= ~loop_updated; }
  inline bool      	pitch_is_updated(void) { return (status & pitch_updated); }
  inline void      	pitch_clear_update(void) { status &= ~pitch_updated; }
  inline bool      	startTime_is_updated(void) { return (status & startTime_updated); }
  inline void      	startTime_clear_update(void) { status &= ~startTime_updated; }
  inline bool      	stopTime_is_updated(void) { return (status & stopTime_updated); }
  inline void      	stopTime_clear_update(void) { status &= ~stopTime_updated; }
  inline bool      	url_is_updated(void) { return (status & url_updated); }
  inline void      	url_clear_update(void) { status &= ~url_updated; }
  inline bool      	duration_changed_is_updated(void) { return (status & duration_changed_updated); }
  inline void      	duration_changed_clear_update(void) { status &= ~duration_changed_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const AudioClip& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_AudioClip_H_*/
