// Billboard.H: Billboard nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Billboard_H_
#define _Billboard_H_

#include "xrml.H"
#include "Transforming.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define BillboardTypeId 	"Billboard"
extern bool IsBillboard(SFNode*);

class Billboard: public virtual SFNode, public Transforming, public Children {
private:
  //
  void clone_here(const Billboard&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    axisOfRotation_updated = 0x1,
    children_updated = 0x2,
    bboxCenter_updated = 0x4,
    bboxSize_updated = 0x8 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Billboard();
  Billboard(const Billboard&);
  Billboard& operator=(const Billboard&);
  virtual ~Billboard();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec3f          	axisOfRotation;
  //  array<Children*> 	children;
  //  SFVec3f          	bboxCenter;
  //  SFVec3f          	bboxSize;
  
  // eventIns:
  void             	addChildren(const MFNode&);
  void             	removeChildren(const MFNode&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_axisOfRotation(const SFVec3f&);
  void             	set_children(const MFNode&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_axisOfRotation(const SFVec3f&);
  bool             	assign_children(const MFNode&);
  bool             	assign_bboxCenter(const SFVec3f&);
  bool             	assign_bboxSize(const SFVec3f&);
  
  // update status
  inline bool      	axisOfRotation_is_updated(void) { return (status & axisOfRotation_updated); }
  inline void      	axisOfRotation_clear_update(void) { status &= ~axisOfRotation_updated; }
  inline bool      	children_is_updated(void) { return (status & children_updated); }
  inline void      	children_clear_update(void) { status &= ~children_updated; }
  inline bool      	bboxCenter_is_updated(void) { return (status & bboxCenter_updated); }
  inline void      	bboxCenter_clear_update(void) { status &= ~bboxCenter_updated; }
  inline bool      	bboxSize_is_updated(void) { return (status & bboxSize_updated); }
  inline void      	bboxSize_clear_update(void) { status &= ~bboxSize_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Billboard& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Billboard_H_*/
