/* Bindable.C: Bindable nodes (public source) */

#include "Bindable.H"
#include "world.H"
#include "StackManager.H"

namespace xrml {

void Bindable::init_stack(void)
{
  stack = 0;
  if (world) world->stacks->checkin(this);
}

void Bindable::set_bind(const SFBool& set)
{
  if (!stack) {
    Error(NULL, "%s: no stack", name());
    return;
  }

  // See VRML'97 ISO standard, section 4.6.10 Bindable children nodes
  if (set) {
    if (stack->top() != this) {
      stack->top()->post_isBound(false);
      stack->push(this);
      post_isBound(true);
    }
  } else {
    if (stack->top() == this) {
      post_isBound(false);
      stack->pop();
      stack->top()->post_isBound(true);
    } else
      stack->remove(this);
  }
}

void Bindable::render(void)
{
  Warning(NULL, "Bindable::render(): not yet implemented");
}

}  // namespace xrml
