// Bindable.H: Bindable nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Bindable_H_
#define _Bindable_H_

#include "xrml.H"

// utility includes
#include "Stack.H"
namespace xrml {
typedef xrml::stack<class Bindable *> bindable_stack;
}
// end of utility includes

namespace xrml {
#define BindableTypeId 	"Bindable"
extern bool IsBindable(SFNode*);

class Bindable: public virtual SFNode {
public:
  //
  virtual int major_version(void), minor_version(void);
  virtual bool is_leaf_class(void);
  
  Bindable();
  
  //
  virtual void     	render(void);
  
  // eventIns:
  virtual void     	set_bind(const SFBool&);
  
  // eventOuts:
  SFBool            	isBound;
  virtual void     	post_isBound(const SFBool& val);
  
  // update status
  virtual bool     	isBound_is_updated(void);
  virtual void     	isBound_clear_update(void);
  
  // utility members
  // With each type of bindable node, a stack is maintained
  // (see world.H, world::stacks member, and bindables.H).
  // The top of these stacks contain the currently active
  // bindable (e.g. Viewpoint). This routine registers the
  // bindable with the stacks maintained by the world to which
  // it belongs.)
  void init_stack(void);

protected:
  friend class StackManager;

  bindable_stack	*stack;

  inline void set_stack(bindable_stack *newstack) {
    stack = newstack;
  }

  inline void util_init(void)  { init_stack(); }
  inline void util_clone(const Bindable& src)  { init_stack(); }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Bindable_H_*/
