/* Box.C: Box nodes (public source) */

#include "Box.H"
#include "renderer.H"

namespace xrml {

void Box::render(void)
{
  world->renderer->box(this);
}

void Box::discretize(void)
{
  float sx = size.x/2.;
  float sy = size.y/2.;
  float sz = size.z/2.;

  SFVec3f coordinates[8] = {
    SFVec3f(-sx, -sy, -sz),
    SFVec3f( sx, -sy, -sz),
    SFVec3f( sx,  sy, -sz),
    SFVec3f(-sx,  sy, -sz),
    SFVec3f(-sx, -sy,  sz),
    SFVec3f( sx, -sy,  sz),
    SFVec3f( sx,  sy,  sz),
    SFVec3f(-sx,  sy,  sz)
  };
  if (co) delete co;
  co = new MFVec3f(8, coordinates);

  SFInt32 coordidx[30] = {
    0, 4, 7, 3, -1,	// -X
    5, 1, 2, 6, -1,	// +X
    0, 1, 5, 4, -1,	// -Y
    7, 6, 2, 3, -1,	// +Y
    1, 0, 3, 2, -1,	// -Z
    4, 5, 6, 7, -1	// +Z
  };
  coordIndex = MFInt32(30, coordidx);

  SFVec3f normals[6] = {
    SFVec3f(-1.,  0,   0.),
    SFVec3f( 1.,  0,   0.),
    SFVec3f( 0., -1.,  0.),
    SFVec3f( 0.,  1.,  0.),
    SFVec3f( 0.,  0., -1.),
    SFVec3f( 0.,  0.,  1.)
  };
  if (norm) delete norm;
  norm = new MFVec3f(6, normals);
  normalIndex = MFInt32(0);	// assign in face order
  normalPerVertex = FALSE;
  creaseAngle = 0.;		// avoid vertex sharing

  SFVec2f texCoords[4] = {
    SFVec2f(0., 0.),
    SFVec2f(1., 0.),
    SFVec2f(1., 1.),
    SFVec2f(0., 1.)
  };
  if (texco) delete texco;
  texco = new MFVec2f(4, texCoords);

  SFInt32 texCoordidx[30] = {
    0, 1, 2, 3, -1,
    0, 1, 2, 3, -1,
    0, 1, 2, 3, -1,
    0, 1, 2, 3, -1,
    0, 1, 2, 3, -1,
    0, 1, 2, 3, -1
  };
  texCoordIndex = MFInt32(30, texCoordidx);
}

}  // namespace xrml
