// Collision.H: Collision nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Collision_H_
#define _Collision_H_

#include "xrml.H"
#include "EnvironmentalSensor.H"
#include "Grouping.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define CollisionTypeId 	"Collision"
extern bool IsCollision(SFNode*);

class Collision: public virtual SFNode, public EnvironmentalSensor, public Grouping, public Children {
private:
  //
  void clone_here(const Collision&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    children_updated = 0x1,
    collide_updated = 0x2,
    bboxCenter_updated = 0x4,
    bboxSize_updated = 0x8,
    proxy_updated = 0x10,
    collideTime_updated = 0x20 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  //  MFNode 	_children;
  //  void 	synchronize_children(void);
  SFNode* 	_proxy;
  void 	synchronize_proxy(void);

  // raw eventOut posting:
  void post_collideTime(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Collision();
  Collision(const Collision&);
  Collision& operator=(const Collision&);
  virtual ~Collision();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  array<Children*> 	children;
  SFBool           	collide;
  //  SFVec3f          	bboxCenter;
  //  SFVec3f          	bboxSize;
  Children*        	proxy;
  
  // eventIns:
  void             	addChildren(const MFNode&);
  void             	removeChildren(const MFNode&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_children(const MFNode&);
  void             	set_collide(const SFBool&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_children(const MFNode&);
  bool             	assign_collide(const SFBool&);
  bool             	assign_bboxCenter(const SFVec3f&);
  bool             	assign_bboxSize(const SFVec3f&);
  bool             	assign_proxy(SFNode*);
  
  // eventOuts:
  SFTime            	collideTime;
  void             	post_collideTime(const SFTime& val);
  
  // update status
  inline bool      	children_is_updated(void) { return (status & children_updated); }
  inline void      	children_clear_update(void) { status &= ~children_updated; }
  inline bool      	collide_is_updated(void) { return (status & collide_updated); }
  inline void      	collide_clear_update(void) { status &= ~collide_updated; }
  inline bool      	bboxCenter_is_updated(void) { return (status & bboxCenter_updated); }
  inline void      	bboxCenter_clear_update(void) { status &= ~bboxCenter_updated; }
  inline bool      	bboxSize_is_updated(void) { return (status & bboxSize_updated); }
  inline void      	bboxSize_clear_update(void) { status &= ~bboxSize_updated; }
  inline bool      	proxy_is_updated(void) { return (status & proxy_updated); }
  inline void      	proxy_clear_update(void) { status &= ~proxy_updated; }
  inline bool      	collideTime_is_updated(void) { return (status & collideTime_updated); }
  inline void      	collideTime_clear_update(void) { status &= ~collideTime_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Collision& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Collision_H_*/
