// ColorInterpolator.H: ColorInterpolator nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _ColorInterpolator_H_
#define _ColorInterpolator_H_

#include "xrml.H"
#include "Interpolator.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define ColorInterpolatorTypeId 	"ColorInterpolator"
extern bool IsColorInterpolator(SFNode*);

class ColorInterpolator: public virtual SFNode, public Interpolator, public Children {
private:
  //
  void clone_here(const ColorInterpolator&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    key_updated = 0x1,
    keyValue_updated = 0x2,
    value_changed_updated = 0x4 
  };
  
protected:
  // raw eventOut posting:
  void post_value_changed(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  ColorInterpolator();
  ColorInterpolator(const ColorInterpolator&);
  ColorInterpolator& operator=(const ColorInterpolator&);
  virtual ~ColorInterpolator();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  MFFloat          	key;
  MFColor          	keyValue;
  
  // eventIns:
  void             	set_fraction(const SFFloat&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_key(const MFFloat&);
  void             	set_keyValue(const MFColor&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_key(const MFFloat&);
  bool             	assign_keyValue(const MFColor&);
  
  // eventOuts:
  SFColor            	value_changed;
  void             	post_value_changed(const SFColor& val);
  
  // update status
  inline bool      	key_is_updated(void) { return (status & key_updated); }
  inline void      	key_clear_update(void) { status &= ~key_updated; }
  inline bool      	keyValue_is_updated(void) { return (status & keyValue_updated); }
  inline void      	keyValue_clear_update(void) { status &= ~keyValue_updated; }
  inline bool      	value_changed_is_updated(void) { return (status & value_changed_updated); }
  inline void      	value_changed_clear_update(void) { status &= ~value_changed_updated; }
  
  // utility members
  
protected:
  SFColor interpolate(float t);

  inline void util_init(void) { }
  inline void util_clone(const ColorInterpolator& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_ColorInterpolator_H_*/
