/* Cone.C: Cone nodes (public source) */

#include "Cone.H"
#include "renderer.H"

namespace xrml {

void Cone::render(void)
{
  world->renderer->cone(this);
}

void Cone::discretize(void)
{
  int nqcd = world->renderer->nrQuartCircleDivisions, n = 4*nqcd;

  if (co) delete co;
  co = new MFVec3f(n+2);
  co->size = n+2;
  if (norm) delete norm;
  norm = new MFVec3f(n+1);
  norm->size = n+1;
  if (texco) delete texco;
  texco = new MFVec2f(3*n+1);
  texco->size = 3*n+1;

  float uu = sqrt(bottomRadius*bottomRadius + height*height);
  float su = bottomRadius / uu;
  float cu = height / uu;
  float h = height/2.;

  for (int i=0; i<n; i++) {
    float t = (float)i/(float)n;
    float s = -sin(2.*M_PI*t);
    float c = -cos(2.*M_PI*t);
    (*co)[i]        = SFVec3f(bottomRadius * s, -h, bottomRadius * c);
    (*norm)[i]      = SFVec3f(s * cu, su, c * cu);
    (*texco)[    i] = SFVec2f(t, 0.);
    (*texco)[n  +i] = SFVec2f(t, 1.);
    (*texco)[2*n+i] = SFVec2f((1.+c)/2., (1.+s)/2.);
  }
  (*co)[n] = SFVec3f(0., h, 0.);
  (*co)[n+1] = SFVec3f(0., -h, 0.);
  (*norm)[n] = SFVec3f(0., -1., 0.);
  (*texco)[3*n] = SFVec2f(0.5, 0.5);

  coordIndex.size = 0;
  coordIndex.grow((side ? n*5 : 0) + (bottom ? n*4 : 0));
  normalIndex.size = 0;
  normalIndex.grow((side ? n*5 : 0) + (bottom ? n*4 : 0));
  texCoordIndex.size = 0;
  texCoordIndex.grow((side ? n*5 : 0) + (bottom ? n*4 : 0));

  int k = 0;
  if (side) {
    for (int i=0; i<n; i++, k+=5) {
      coordIndex[k  ] = i;
      coordIndex[k+1] = (i+1)%n;
      coordIndex[k+2] = n;
      coordIndex[k+3] = n;
      coordIndex[k+4] = -1;	// end of face marker

      normalIndex[k  ] = i;
      normalIndex[k+1] = (i+1)%n;
      normalIndex[k+2] = (i+1)%n;
      normalIndex[k+3] = i;
      normalIndex[k+4] = -1;

      texCoordIndex[k  ] = i;
      texCoordIndex[k+1] = (i+1)%n;
      texCoordIndex[k+2] = n+(i+1)%n;
      texCoordIndex[k+3] = n+i;
      texCoordIndex[k+4] = -1;      
    }
  }
  if (bottom) {
    for (int i=0; i<n; i++, k+=4) {
      coordIndex[k  ] = (i+1)%n;
      coordIndex[k+1] = i;
      coordIndex[k+2] = n+1;
      coordIndex[k+3] = -1;	// end of face marker

      normalIndex[k  ] = n;
      normalIndex[k+1] = n;
      normalIndex[k+2] = n;
      normalIndex[k+3] = -1;

      texCoordIndex[k  ] = 2*n + (i+1)%n;
      texCoordIndex[k+1] = 2*n + i;
      texCoordIndex[k+2] = 3*n;
      texCoordIndex[k+3] = -1;
    }
  }
}

}  // namespace xrml
