// DirectionalLight.H: DirectionalLight nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _DirectionalLight_H_
#define _DirectionalLight_H_

#include "xrml.H"
#include "Children.H"
#include "LightSource.H"

// utility includes
// end of utility includes

namespace xrml {
#define DirectionalLightTypeId 	"DirectionalLight"
extern bool IsDirectionalLight(SFNode*);

class DirectionalLight: public virtual SFNode, public Children, public LightSource {
private:
  //
  void clone_here(const DirectionalLight&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    ambientIntensity_updated = 0x1,
    color_updated = 0x2,
    direction_updated = 0x4,
    intensity_updated = 0x8,
    on_updated = 0x10 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  DirectionalLight();
  DirectionalLight(const DirectionalLight&);
  DirectionalLight& operator=(const DirectionalLight&);
  virtual ~DirectionalLight();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  SFFloat          	ambientIntensity;
  //  SFColor          	color;
  SFVec3f          	direction;
  //  SFFloat          	intensity;
  //  SFBool           	on;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_ambientIntensity(const SFFloat&);
  void             	set_color(const SFColor&);
  void             	set_direction(const SFVec3f&);
  void             	set_intensity(const SFFloat&);
  void             	set_on(const SFBool&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_ambientIntensity(const SFFloat&);
  bool             	assign_color(const SFColor&);
  bool             	assign_direction(const SFVec3f&);
  bool             	assign_intensity(const SFFloat&);
  bool             	assign_on(const SFBool&);
  
  // update status
  inline bool      	ambientIntensity_is_updated(void) { return (status & ambientIntensity_updated); }
  inline void      	ambientIntensity_clear_update(void) { status &= ~ambientIntensity_updated; }
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	direction_is_updated(void) { return (status & direction_updated); }
  inline void      	direction_clear_update(void) { status &= ~direction_updated; }
  inline bool      	intensity_is_updated(void) { return (status & intensity_updated); }
  inline void      	intensity_clear_update(void) { status &= ~intensity_updated; }
  inline bool      	on_is_updated(void) { return (status & on_updated); }
  inline void      	on_clear_update(void) { status &= ~on_updated; }
  
  // utility members
  void 		begin_render(void);
  void 		end_render(void);

protected:
  inline void util_init(void) { }
  inline void util_clone(const DirectionalLight& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_DirectionalLight_H_*/
