// ElevationGrid.H: ElevationGrid nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _ElevationGrid_H_
#define _ElevationGrid_H_

#include "xrml.H"
#include "Geometry.H"
#include "Color.H"
#include "Normal.H"
#include "TextureCoordinate.H"

// utility includes
// end of utility includes

namespace xrml {
#define ElevationGridTypeId 	"ElevationGrid"
extern bool IsElevationGrid(SFNode*);

class ElevationGrid: public virtual SFNode, public Geometry {
private:
  //
  void clone_here(const ElevationGrid&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    color_updated = 0x1,
    normal_updated = 0x2,
    texCoord_updated = 0x4,
    height_updated = 0x8,
    ccw_updated = 0x10,
    colorPerVertex_updated = 0x20,
    creaseAngle_updated = 0x40,
    normalPerVertex_updated = 0x80,
    solid_updated = 0x100,
    xDimension_updated = 0x200,
    xSpacing_updated = 0x400,
    zDimension_updated = 0x800,
    zSpacing_updated = 0x1000 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_color;
  void 	synchronize_color(void);
  SFNode* 	_normal;
  void 	synchronize_normal(void);
  SFNode* 	_texCoord;
  void 	synchronize_texCoord(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  ElevationGrid();
  ElevationGrid(const ElevationGrid&);
  ElevationGrid& operator=(const ElevationGrid&);
  virtual ~ElevationGrid();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  Color*           	color;
  Normal*          	normal;
  TextureCoordinate* 	texCoord;
  MFFloat          	height;
  //  SFBool           	ccw;
  //  SFBool           	colorPerVertex;
  //  SFFloat          	creaseAngle;
  //  SFBool           	normalPerVertex;
  //  SFBool           	solid;
  SFInt32          	xDimension;
  SFFloat          	xSpacing;
  SFInt32          	zDimension;
  SFFloat          	zSpacing;
  
  // eventIns:
  void             	set_height(const MFFloat&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_color(SFNode*);
  void             	set_normal(SFNode*);
  void             	set_texCoord(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_color(SFNode*);
  bool             	assign_normal(SFNode*);
  bool             	assign_texCoord(SFNode*);
  bool             	assign_height(const MFFloat&);
  bool             	assign_ccw(const SFBool&);
  bool             	assign_colorPerVertex(const SFBool&);
  bool             	assign_creaseAngle(const SFFloat&);
  bool             	assign_normalPerVertex(const SFBool&);
  bool             	assign_solid(const SFBool&);
  bool             	assign_xDimension(const SFInt32&);
  bool             	assign_xSpacing(const SFFloat&);
  bool             	assign_zDimension(const SFInt32&);
  bool             	assign_zSpacing(const SFFloat&);
  
  // update status
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	normal_is_updated(void) { return (status & normal_updated); }
  inline void      	normal_clear_update(void) { status &= ~normal_updated; }
  inline bool      	texCoord_is_updated(void) { return (status & texCoord_updated); }
  inline void      	texCoord_clear_update(void) { status &= ~texCoord_updated; }
  inline bool      	height_is_updated(void) { return (status & height_updated); }
  inline void      	height_clear_update(void) { status &= ~height_updated; }
  inline bool      	ccw_is_updated(void) { return (status & ccw_updated); }
  inline void      	ccw_clear_update(void) { status &= ~ccw_updated; }
  inline bool      	colorPerVertex_is_updated(void) { return (status & colorPerVertex_updated); }
  inline void      	colorPerVertex_clear_update(void) { status &= ~colorPerVertex_updated; }
  inline bool      	creaseAngle_is_updated(void) { return (status & creaseAngle_updated); }
  inline void      	creaseAngle_clear_update(void) { status &= ~creaseAngle_updated; }
  inline bool      	normalPerVertex_is_updated(void) { return (status & normalPerVertex_updated); }
  inline void      	normalPerVertex_clear_update(void) { status &= ~normalPerVertex_updated; }
  inline bool      	solid_is_updated(void) { return (status & solid_updated); }
  inline void      	solid_clear_update(void) { status &= ~solid_updated; }
  inline bool      	xDimension_is_updated(void) { return (status & xDimension_updated); }
  inline void      	xDimension_clear_update(void) { status &= ~xDimension_updated; }
  inline bool      	xSpacing_is_updated(void) { return (status & xSpacing_updated); }
  inline void      	xSpacing_clear_update(void) { status &= ~xSpacing_updated; }
  inline bool      	zDimension_is_updated(void) { return (status & zDimension_updated); }
  inline void      	zDimension_clear_update(void) { status &= ~zDimension_updated; }
  inline bool      	zSpacing_is_updated(void) { return (status & zSpacing_updated); }
  inline void      	zSpacing_clear_update(void) { status &= ~zSpacing_updated; }
  
  // utility members
  void discretize(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const ElevationGrid& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_ElevationGrid_H_*/
