// Extrusion.H: Extrusion nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Extrusion_H_
#define _Extrusion_H_

#include "xrml.H"
#include "Geometry.H"

// utility includes
// end of utility includes

namespace xrml {
#define ExtrusionTypeId 	"Extrusion"
extern bool IsExtrusion(SFNode*);

class Extrusion: public virtual SFNode, public Geometry {
private:
  //
  void clone_here(const Extrusion&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    beginCap_updated = 0x1,
    ccw_updated = 0x2,
    convex_updated = 0x4,
    creaseAngle_updated = 0x8,
    crossSection_updated = 0x10,
    endCap_updated = 0x20,
    orientation_updated = 0x40,
    scale_updated = 0x80,
    solid_updated = 0x100,
    spine_updated = 0x200 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Extrusion();
  Extrusion(const Extrusion&);
  Extrusion& operator=(const Extrusion&);
  virtual ~Extrusion();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFBool           	beginCap;
  //  SFBool           	ccw;
  //  SFBool           	convex;
  //  SFFloat          	creaseAngle;
  MFVec2f          	crossSection;
  SFBool           	endCap;
  MFRotation       	orientation;
  MFVec2f          	scale;
  //  SFBool           	solid;
  MFVec3f          	spine;
  
  // eventIns:
  void             	set_crossSection(const MFVec2f&);
  void             	set_orientation(const MFRotation&);
  void             	set_scale(const MFVec2f&);
  void             	set_spine(const MFVec3f&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_beginCap(const SFBool&);
  bool             	assign_ccw(const SFBool&);
  bool             	assign_convex(const SFBool&);
  bool             	assign_creaseAngle(const SFFloat&);
  bool             	assign_crossSection(const MFVec2f&);
  bool             	assign_endCap(const SFBool&);
  bool             	assign_orientation(const MFRotation&);
  bool             	assign_scale(const MFVec2f&);
  bool             	assign_solid(const SFBool&);
  bool             	assign_spine(const MFVec3f&);
  
  // update status
  inline bool      	beginCap_is_updated(void) { return (status & beginCap_updated); }
  inline void      	beginCap_clear_update(void) { status &= ~beginCap_updated; }
  inline bool      	ccw_is_updated(void) { return (status & ccw_updated); }
  inline void      	ccw_clear_update(void) { status &= ~ccw_updated; }
  inline bool      	convex_is_updated(void) { return (status & convex_updated); }
  inline void      	convex_clear_update(void) { status &= ~convex_updated; }
  inline bool      	creaseAngle_is_updated(void) { return (status & creaseAngle_updated); }
  inline void      	creaseAngle_clear_update(void) { status &= ~creaseAngle_updated; }
  inline bool      	crossSection_is_updated(void) { return (status & crossSection_updated); }
  inline void      	crossSection_clear_update(void) { status &= ~crossSection_updated; }
  inline bool      	endCap_is_updated(void) { return (status & endCap_updated); }
  inline void      	endCap_clear_update(void) { status &= ~endCap_updated; }
  inline bool      	orientation_is_updated(void) { return (status & orientation_updated); }
  inline void      	orientation_clear_update(void) { status &= ~orientation_updated; }
  inline bool      	scale_is_updated(void) { return (status & scale_updated); }
  inline void      	scale_clear_update(void) { status &= ~scale_updated; }
  inline bool      	solid_is_updated(void) { return (status & solid_updated); }
  inline void      	solid_clear_update(void) { status &= ~solid_updated; }
  inline bool      	spine_is_updated(void) { return (status & spine_updated); }
  inline void      	spine_clear_update(void) { status &= ~spine_updated; }
  
  // utility members
  void discretize(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Extrusion& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Extrusion_H_*/
