// Fog.H: Fog nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Fog_H_
#define _Fog_H_

#include "xrml.H"
#include "Bindable.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define FogTypeId 	"Fog"
extern bool IsFog(SFNode*);

class Fog: public virtual SFNode, public Bindable, public Children {
private:
  //
  void clone_here(const Fog&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    color_updated = 0x1,
    fogType_updated = 0x2,
    visibilityRange_updated = 0x4,
    isBound_updated = 0x8 
  };
  
protected:
  // raw eventOut posting:
  void post_isBound(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Fog();
  Fog(const Fog&);
  Fog& operator=(const Fog&);
  virtual ~Fog();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFColor          	color;
  SFString         	fogType;
  SFFloat          	visibilityRange;
  
  // eventIns:
  void             	set_bind(const SFBool&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_color(const SFColor&);
  void             	set_fogType(const SFString&);
  void             	set_visibilityRange(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_color(const SFColor&);
  bool             	assign_fogType(const SFString&);
  bool             	assign_visibilityRange(const SFFloat&);
  
  // eventOuts:
  //  SFBool            	isBound;
  void             	post_isBound(const SFBool& val);
  
  // update status
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	fogType_is_updated(void) { return (status & fogType_updated); }
  inline void      	fogType_clear_update(void) { status &= ~fogType_updated; }
  inline bool      	visibilityRange_is_updated(void) { return (status & visibilityRange_updated); }
  inline void      	visibilityRange_clear_update(void) { status &= ~visibilityRange_updated; }
  inline bool      	isBound_is_updated(void) { return (status & isBound_updated); }
  inline void      	isBound_clear_update(void) { status &= ~isBound_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Fog& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Fog_H_*/
