// Geometry.H: Geometry nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Geometry_H_
#define _Geometry_H_

#include "xrml.H"

// utility includes
// end of utility includes

namespace xrml {
#define GeometryTypeId 	"Geometry"
extern bool IsGeometry(SFNode*);

class Geometry: public virtual SFNode {
public:
  //
  virtual int major_version(void), minor_version(void);
  virtual bool is_leaf_class(void);
  
  Geometry();
  
  //
  virtual void     	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFBool           	ccw;
  MFInt32          	colorIndex;
  SFBool           	colorPerVertex;
  SFBool           	convex;
  MFInt32          	coordIndex;
  SFFloat          	creaseAngle;
  MFInt32          	normalIndex;
  SFBool           	normalPerVertex;
  SFBool           	solid;
  MFInt32          	texCoordIndex;
  
  // field assignement: no forwarding or eventOut generation!
  virtual bool     	assign_ccw(const SFBool&);
  virtual bool     	assign_colorIndex(const MFInt32&);
  virtual bool     	assign_colorPerVertex(const SFBool&);
  virtual bool     	assign_convex(const SFBool&);
  virtual bool     	assign_coordIndex(const MFInt32&);
  virtual bool     	assign_creaseAngle(const SFFloat&);
  virtual bool     	assign_normalIndex(const MFInt32&);
  virtual bool     	assign_normalPerVertex(const SFBool&);
  virtual bool     	assign_solid(const SFBool&);
  virtual bool     	assign_texCoordIndex(const MFInt32&);
  
  // update status
  virtual bool     	ccw_is_updated(void);
  virtual void     	ccw_clear_update(void);
  virtual bool     	colorIndex_is_updated(void);
  virtual void     	colorIndex_clear_update(void);
  virtual bool     	colorPerVertex_is_updated(void);
  virtual void     	colorPerVertex_clear_update(void);
  virtual bool     	convex_is_updated(void);
  virtual void     	convex_clear_update(void);
  virtual bool     	coordIndex_is_updated(void);
  virtual void     	coordIndex_clear_update(void);
  virtual bool     	creaseAngle_is_updated(void);
  virtual void     	creaseAngle_clear_update(void);
  virtual bool     	normalIndex_is_updated(void);
  virtual void     	normalIndex_clear_update(void);
  virtual bool     	normalPerVertex_is_updated(void);
  virtual void     	normalPerVertex_clear_update(void);
  virtual bool     	solid_is_updated(void);
  virtual void     	solid_clear_update(void);
  virtual bool     	texCoordIndex_is_updated(void);
  virtual void     	texCoordIndex_clear_update(void);
  
  // utility members
  // colors, coordinates, normals, texture coordinates generated with 
  // discretize()
  MFColor *	 col;
  MFVec3f *	 co;
  MFVec3f *	 norm;
  MFVec2f *	 texco;

  // discretizes the geometry
  virtual void discretize(void);
  
protected:
  inline void util_init(void) 
  { 
    col=0; co=0; norm=0; texco=0; 
  }

  inline void util_clone(const Geometry& src)  
  {
    col=0; co=0; norm=0; texco=0; 
  }

  inline void util_destruct(void) 
  {
    if (col) delete col;
    if (co) delete co;
    if (norm) delete norm;
    if (texco) delete texco;
  }
};

// end of utility members
} // namespace xrml
#endif /*_Geometry_H_*/
