/* Grouping.C: Grouping nodes (public source) */

#include "Grouping.H"
#include "LightSource.H"

namespace xrml {

void Grouping::addChildren(const MFNode&)
{
  Warning(NULL, "Grouping::addChildren(): not yet implemented");
}

void Grouping::removeChildren(const MFNode&)
{
  Warning(NULL, "Grouping::removeChildren(): not yet implemented");
}

void Grouping::render(void)
{
  int i;

  // switch on light sources in this group
  for (i=0; i<children.size; i++) {
    if (IsLightSource(children[i]))
      dynamic_cast<LightSource*>(children[i])->begin_render();
  }

  // render the other children nodes
  for (i=0; i<children.size; i++) {
    if (!IsLightSource(children[i]))
      children[i]->render();
  }

  // switch off the lights in this group in reverse order
  for (i=children.size-1; i>=0; i--) {
    if (IsLightSource(children[i]))
      dynamic_cast<LightSource*>(children[i])->end_render();
  }
}

}  // namespace xrml
