// IndexedFaceSet.H: IndexedFaceSet nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _IndexedFaceSet_H_
#define _IndexedFaceSet_H_

#include "xrml.H"
#include "Geometry.H"
#include "Color.H"
#include "Coordinate.H"
#include "Normal.H"
#include "TextureCoordinate.H"

// utility includes
// end of utility includes

namespace xrml {
#define IndexedFaceSetTypeId 	"IndexedFaceSet"
extern bool IsIndexedFaceSet(SFNode*);

class IndexedFaceSet: public virtual SFNode, public Geometry {
private:
  //
  void clone_here(const IndexedFaceSet&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    color_updated = 0x1,
    coord_updated = 0x2,
    normal_updated = 0x4,
    texCoord_updated = 0x8,
    ccw_updated = 0x10,
    colorIndex_updated = 0x20,
    colorPerVertex_updated = 0x40,
    convex_updated = 0x80,
    coordIndex_updated = 0x100,
    creaseAngle_updated = 0x200,
    normalIndex_updated = 0x400,
    normalPerVertex_updated = 0x800,
    solid_updated = 0x1000,
    texCoordIndex_updated = 0x2000 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_color;
  void 	synchronize_color(void);
  SFNode* 	_coord;
  void 	synchronize_coord(void);
  SFNode* 	_normal;
  void 	synchronize_normal(void);
  SFNode* 	_texCoord;
  void 	synchronize_texCoord(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  IndexedFaceSet();
  IndexedFaceSet(const IndexedFaceSet&);
  IndexedFaceSet& operator=(const IndexedFaceSet&);
  virtual ~IndexedFaceSet();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  Color*           	color;
  Coordinate*      	coord;
  Normal*          	normal;
  TextureCoordinate* 	texCoord;
  //  SFBool           	ccw;
  //  MFInt32          	colorIndex;
  //  SFBool           	colorPerVertex;
  //  SFBool           	convex;
  //  MFInt32          	coordIndex;
  //  SFFloat          	creaseAngle;
  //  MFInt32          	normalIndex;
  //  SFBool           	normalPerVertex;
  //  SFBool           	solid;
  //  MFInt32          	texCoordIndex;
  
  // eventIns:
  void             	set_colorIndex(const MFInt32&);
  void             	set_coordIndex(const MFInt32&);
  void             	set_normalIndex(const MFInt32&);
  void             	set_texCoordIndex(const MFInt32&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_color(SFNode*);
  void             	set_coord(SFNode*);
  void             	set_normal(SFNode*);
  void             	set_texCoord(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_color(SFNode*);
  bool             	assign_coord(SFNode*);
  bool             	assign_normal(SFNode*);
  bool             	assign_texCoord(SFNode*);
  bool             	assign_ccw(const SFBool&);
  bool             	assign_colorIndex(const MFInt32&);
  bool             	assign_colorPerVertex(const SFBool&);
  bool             	assign_convex(const SFBool&);
  bool             	assign_coordIndex(const MFInt32&);
  bool             	assign_creaseAngle(const SFFloat&);
  bool             	assign_normalIndex(const MFInt32&);
  bool             	assign_normalPerVertex(const SFBool&);
  bool             	assign_solid(const SFBool&);
  bool             	assign_texCoordIndex(const MFInt32&);
  
  // update status
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	coord_is_updated(void) { return (status & coord_updated); }
  inline void      	coord_clear_update(void) { status &= ~coord_updated; }
  inline bool      	normal_is_updated(void) { return (status & normal_updated); }
  inline void      	normal_clear_update(void) { status &= ~normal_updated; }
  inline bool      	texCoord_is_updated(void) { return (status & texCoord_updated); }
  inline void      	texCoord_clear_update(void) { status &= ~texCoord_updated; }
  inline bool      	ccw_is_updated(void) { return (status & ccw_updated); }
  inline void      	ccw_clear_update(void) { status &= ~ccw_updated; }
  inline bool      	colorIndex_is_updated(void) { return (status & colorIndex_updated); }
  inline void      	colorIndex_clear_update(void) { status &= ~colorIndex_updated; }
  inline bool      	colorPerVertex_is_updated(void) { return (status & colorPerVertex_updated); }
  inline void      	colorPerVertex_clear_update(void) { status &= ~colorPerVertex_updated; }
  inline bool      	convex_is_updated(void) { return (status & convex_updated); }
  inline void      	convex_clear_update(void) { status &= ~convex_updated; }
  inline bool      	coordIndex_is_updated(void) { return (status & coordIndex_updated); }
  inline void      	coordIndex_clear_update(void) { status &= ~coordIndex_updated; }
  inline bool      	creaseAngle_is_updated(void) { return (status & creaseAngle_updated); }
  inline void      	creaseAngle_clear_update(void) { status &= ~creaseAngle_updated; }
  inline bool      	normalIndex_is_updated(void) { return (status & normalIndex_updated); }
  inline void      	normalIndex_clear_update(void) { status &= ~normalIndex_updated; }
  inline bool      	normalPerVertex_is_updated(void) { return (status & normalPerVertex_updated); }
  inline void      	normalPerVertex_clear_update(void) { status &= ~normalPerVertex_updated; }
  inline bool      	solid_is_updated(void) { return (status & solid_updated); }
  inline void      	solid_clear_update(void) { status &= ~solid_updated; }
  inline bool      	texCoordIndex_is_updated(void) { return (status & texCoordIndex_updated); }
  inline void      	texCoordIndex_clear_update(void) { status &= ~texCoordIndex_updated; }
  
  // utility members
  void discretize(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const IndexedFaceSet& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_IndexedFaceSet_H_*/
