// IndexedLineSet.H: IndexedLineSet nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _IndexedLineSet_H_
#define _IndexedLineSet_H_

#include "xrml.H"
#include "Geometry.H"
#include "Color.H"
#include "Coordinate.H"

// utility includes
// end of utility includes

namespace xrml {
#define IndexedLineSetTypeId 	"IndexedLineSet"
extern bool IsIndexedLineSet(SFNode*);

class IndexedLineSet: public virtual SFNode, public Geometry {
private:
  //
  void clone_here(const IndexedLineSet&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    color_updated = 0x1,
    coord_updated = 0x2,
    colorIndex_updated = 0x4,
    colorPerVertex_updated = 0x8,
    coordIndex_updated = 0x10 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_color;
  void 	synchronize_color(void);
  SFNode* 	_coord;
  void 	synchronize_coord(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  IndexedLineSet();
  IndexedLineSet(const IndexedLineSet&);
  IndexedLineSet& operator=(const IndexedLineSet&);
  virtual ~IndexedLineSet();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  Color*           	color;
  Coordinate*      	coord;
  //  MFInt32          	colorIndex;
  //  SFBool           	colorPerVertex;
  //  MFInt32          	coordIndex;
  
  // eventIns:
  void             	set_colorIndex(const MFInt32&);
  void             	set_coordIndex(const MFInt32&);
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_color(SFNode*);
  void             	set_coord(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_color(SFNode*);
  bool             	assign_coord(SFNode*);
  bool             	assign_colorIndex(const MFInt32&);
  bool             	assign_colorPerVertex(const SFBool&);
  bool             	assign_coordIndex(const MFInt32&);
  
  // update status
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	coord_is_updated(void) { return (status & coord_updated); }
  inline void      	coord_clear_update(void) { status &= ~coord_updated; }
  inline bool      	colorIndex_is_updated(void) { return (status & colorIndex_updated); }
  inline void      	colorIndex_clear_update(void) { status &= ~colorIndex_updated; }
  inline bool      	colorPerVertex_is_updated(void) { return (status & colorPerVertex_updated); }
  inline void      	colorPerVertex_clear_update(void) { status &= ~colorPerVertex_updated; }
  inline bool      	coordIndex_is_updated(void) { return (status & coordIndex_updated); }
  inline void      	coordIndex_clear_update(void) { status &= ~coordIndex_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const IndexedLineSet& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_IndexedLineSet_H_*/
