/* Inline.C: Inline nodes (public source) */

#include "Inline.H"
#include "renderer.H"
#include "file.H"

namespace xrml {

void Inline::load(void)
{
  inline_world = new class world;
  inline_world->init(world->time);
  class file *file = world->openFileFromURLs(url);
  if (file) {
    inline_world->parse(file, world->time);
    file->close();
  }
}

void Inline::render(void)
{
  // load children nodes if not yet loaded
  if (!inline_world) {
    load();
    inline_world->set_renderer(world->renderer);
  }
  inline_world->rendernewframe(world->time);
}

}  // namespace xrml
