// Inline.H: Inline nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Inline_H_
#define _Inline_H_

#include "xrml.H"
#include "Grouping.H"
#include "Children.H"

// utility includes
#include "world.H"
// end of utility includes

namespace xrml {
#define InlineTypeId 	"Inline"
extern bool IsInline(SFNode*);

class Inline: public virtual SFNode, public Grouping, public Children {
private:
  //
  void clone_here(const Inline&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    url_updated = 0x1,
    bboxCenter_updated = 0x2,
    bboxSize_updated = 0x4 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Inline();
  Inline(const Inline&);
  Inline& operator=(const Inline&);
  virtual ~Inline();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  MFString         	url;
  //  SFVec3f          	bboxCenter;
  //  SFVec3f          	bboxSize;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_url(const MFString&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_url(const MFString&);
  bool             	assign_bboxCenter(const SFVec3f&);
  bool             	assign_bboxSize(const SFVec3f&);
  
  // update status
  inline bool      	url_is_updated(void) { return (status & url_updated); }
  inline void      	url_clear_update(void) { status &= ~url_updated; }
  inline bool      	bboxCenter_is_updated(void) { return (status & bboxCenter_updated); }
  inline void      	bboxCenter_clear_update(void) { status &= ~bboxCenter_updated; }
  inline bool      	bboxSize_is_updated(void) { return (status & bboxSize_updated); }
  inline void      	bboxSize_clear_update(void) { status &= ~bboxSize_updated; }
  
  // utility members
  char *base_url;
  
protected:
  class world *inline_world;
  void load(void);	// loads the inline children

  inline void util_init(void)
  {
    inline_world = 0;
    base_url = 0; 
  }

  inline void util_clone(const Inline& src) 
  {
    inline_world = 0; 
    base_url = src.base_url ? strdup(src.base_url) : 0;
  }

  inline void util_destruct(void) 
  { 
    if (inline_world) delete inline_world; 
    if (base_url) delete base_url;
  }
};

// end of utility members
} // namespace xrml
#endif /*_Inline_H_*/
