/* Interpolator.C: Interpolator nodes (public source) */

#include "Interpolator.H"

namespace xrml {

float Interpolator::get_index(float t)
{
  if (key.size <= 0)
    return -1.;
  if (t <= key[0])
    return 0.;
  for (int i=1; i<key.size; i++)
    if (t < key[i])
      return (float)(i-1) + (t-key[i-1]) / (key[i] - key[i-1]);
  return key.size-1;	// t >= key[key.size-1]
}

void Interpolator::set_fraction(const SFFloat& t)
{
  Warning(NULL, "Interpolator::set_fraction(): not yet implemented");
}

void Interpolator::render(void)
{
  Warning(NULL, "Interpolator::render(): not yet implemented");
}

}  // namespace xrml
