// LOD.H: LOD nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _LOD_H_
#define _LOD_H_

#include "xrml.H"
#include "Grouping.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define LODTypeId 	"LOD"
extern bool IsLOD(SFNode*);

class LOD: public virtual SFNode, public Grouping, public Children {
private:
  //
  void clone_here(const LOD&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    level_updated = 0x1,
    center_updated = 0x2,
    range_updated = 0x4 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  MFNode 	_level;
  void 	synchronize_level(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  LOD();
  LOD(const LOD&);
  LOD& operator=(const LOD&);
  virtual ~LOD();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  array<Children*> 	level;
  SFVec3f          	center;
  MFFloat          	range;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_level(const MFNode&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_level(const MFNode&);
  bool             	assign_center(const SFVec3f&);
  bool             	assign_range(const MFFloat&);
  
  // update status
  inline bool      	level_is_updated(void) { return (status & level_updated); }
  inline void      	level_clear_update(void) { status &= ~level_updated; }
  inline bool      	center_is_updated(void) { return (status & center_updated); }
  inline void      	center_clear_update(void) { status &= ~center_updated; }
  inline bool      	range_is_updated(void) { return (status & range_updated); }
  inline void      	range_clear_update(void) { status &= ~range_updated; }
  
  // utility members
  // to be computed by world->renderer->begin_LOD()
  int		whichLevel;

protected:
  inline void util_init(void) { whichLevel = 0; }
  inline void util_clone(const LOD& src) { whichLevel = 0; }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_LOD_H_*/
