// Material.H: Material nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Material_H_
#define _Material_H_

#include "xrml.H"

// utility includes
// end of utility includes

namespace xrml {
#define MaterialTypeId 	"Material"
extern bool IsMaterial(SFNode*);

class Material: public virtual SFNode {
private:
  //
  void clone_here(const Material&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    ambientIntensity_updated = 0x1,
    diffuseColor_updated = 0x2,
    emissiveColor_updated = 0x4,
    shininess_updated = 0x8,
    specularColor_updated = 0x10,
    transparency_updated = 0x20 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Material();
  Material(const Material&);
  Material& operator=(const Material&);
  virtual ~Material();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFFloat          	ambientIntensity;
  SFColor          	diffuseColor;
  SFColor          	emissiveColor;
  SFFloat          	shininess;
  SFColor          	specularColor;
  SFFloat          	transparency;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_ambientIntensity(const SFFloat&);
  void             	set_diffuseColor(const SFColor&);
  void             	set_emissiveColor(const SFColor&);
  void             	set_shininess(const SFFloat&);
  void             	set_specularColor(const SFColor&);
  void             	set_transparency(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_ambientIntensity(const SFFloat&);
  bool             	assign_diffuseColor(const SFColor&);
  bool             	assign_emissiveColor(const SFColor&);
  bool             	assign_shininess(const SFFloat&);
  bool             	assign_specularColor(const SFColor&);
  bool             	assign_transparency(const SFFloat&);
  
  // update status
  inline bool      	ambientIntensity_is_updated(void) { return (status & ambientIntensity_updated); }
  inline void      	ambientIntensity_clear_update(void) { status &= ~ambientIntensity_updated; }
  inline bool      	diffuseColor_is_updated(void) { return (status & diffuseColor_updated); }
  inline void      	diffuseColor_clear_update(void) { status &= ~diffuseColor_updated; }
  inline bool      	emissiveColor_is_updated(void) { return (status & emissiveColor_updated); }
  inline void      	emissiveColor_clear_update(void) { status &= ~emissiveColor_updated; }
  inline bool      	shininess_is_updated(void) { return (status & shininess_updated); }
  inline void      	shininess_clear_update(void) { status &= ~shininess_updated; }
  inline bool      	specularColor_is_updated(void) { return (status & specularColor_updated); }
  inline void      	specularColor_clear_update(void) { status &= ~specularColor_updated; }
  inline bool      	transparency_is_updated(void) { return (status & transparency_updated); }
  inline void      	transparency_clear_update(void) { status &= ~transparency_updated; }
  
  // utility members
  virtual void    	begin_render(void);
  virtual void    	end_render(void);

protected:
  inline void util_init(void) { }
  inline void util_clone(const Material& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Material_H_*/
