// MovieTexture.H: MovieTexture nodes.

// This file has been generated using nodegen 0.51.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _MovieTexture_H_
#define _MovieTexture_H_

#include "xrml.H"
#include "TimeDependent.H"
#include "SoundSource.H"
#include "Texture.H"

// utility includes
// end of utility includes

namespace xrml {
#define MovieTextureTypeId 	"MovieTexture"
extern bool IsMovieTexture(SFNode*);

class MovieTexture: public virtual SFNode, public TimeDependent, public SoundSource, public Texture {
private:
  //
  void clone_here(const MovieTexture&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    loop_updated = 0x1,
    speed_updated = 0x2,
    startTime_updated = 0x4,
    stopTime_updated = 0x8,
    url_updated = 0x10,
    repeatS_updated = 0x20,
    repeatT_updated = 0x40,
    duration_changed_updated = 0x80,
    isActive_updated = 0x100 
  };
  
protected:
  // raw eventOut posting:
  void post_duration_changed(void);
  void post_isActive(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  MovieTexture();
  MovieTexture(const MovieTexture&);
  MovieTexture& operator=(const MovieTexture&);
  virtual ~MovieTexture();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  SFBool           	loop;
  SFFloat          	speed;
  //  SFTime           	startTime;
  //  SFTime           	stopTime;
  MFString         	url;
  //  SFBool           	repeatS;
  //  SFBool           	repeatT;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_loop(const SFBool&);
  void             	set_speed(const SFFloat&);
  void             	set_startTime(const SFTime&);
  void             	set_stopTime(const SFTime&);
  void             	set_url(const MFString&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_loop(const SFBool&);
  bool             	assign_speed(const SFFloat&);
  bool             	assign_startTime(const SFTime&);
  bool             	assign_stopTime(const SFTime&);
  bool             	assign_url(const MFString&);
  bool             	assign_repeatS(const SFBool&);
  bool             	assign_repeatT(const SFBool&);
  
  // eventOuts:
  SFTime            	duration_changed;
  void             	post_duration_changed(const SFTime& val);
  //  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  
  // update status
  inline bool      	loop_is_updated(void) { return (status & loop_updated); }
  inline void      	loop_clear_update(void) { status &= ~loop_updated; }
  inline bool      	speed_is_updated(void) { return (status & speed_updated); }
  inline void      	speed_clear_update(void) { status &= ~speed_updated; }
  inline bool      	startTime_is_updated(void) { return (status & startTime_updated); }
  inline void      	startTime_clear_update(void) { status &= ~startTime_updated; }
  inline bool      	stopTime_is_updated(void) { return (status & stopTime_updated); }
  inline void      	stopTime_clear_update(void) { status &= ~stopTime_updated; }
  inline bool      	url_is_updated(void) { return (status & url_updated); }
  inline void      	url_clear_update(void) { status &= ~url_updated; }
  inline bool      	repeatS_is_updated(void) { return (status & repeatS_updated); }
  inline void      	repeatS_clear_update(void) { status &= ~repeatS_updated; }
  inline bool      	repeatT_is_updated(void) { return (status & repeatT_updated); }
  inline void      	repeatT_clear_update(void) { status &= ~repeatT_updated; }
  inline bool      	duration_changed_is_updated(void) { return (status & duration_changed_updated); }
  inline void      	duration_changed_clear_update(void) { status &= ~duration_changed_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  
  // utility members
  void		begin_render(void);
  void		end_render(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const MovieTexture& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_MovieTexture_H_*/
