/* NormalInterpolator.C: NormalInterpolator nodes (public source) */

#include <math.h>
#include "NormalInterpolator.H"
#include "vector.H"

namespace xrml {

static SFVec3f Normal_interpolate(const SFVec3f& n1, const SFVec3f& n2, float t)
{
  // TODO: should interpolate along an arc on the unit sphere, connecting
  // n1 and n2.
  float s = 1.-t;
  Vec3 n = Vec3(n1.x * s + n2.x * t,
		n1.y * s + n2.y * t,
		n1.z * s + n2.z * t).normalize();
  return SFVec3f(n.x, n.y, n.z);
}

MFVec3f NormalInterpolator::interpolate(float t)
{
  MFVec3f n(values_per_key);
  int i = (int)floor(t);
  int ip1 = (int)ceil(t);
  if (i == ip1) {
    for (int j=0; j<values_per_key; j++)
      n[j] = keyValue[i*values_per_key + j];
  } else {
    for (int j=0; j<values_per_key; j++)
      n[j] = Normal_interpolate(keyValue[i*values_per_key+j], keyValue[ip1*values_per_key+j], t);
  }
  return n;
}

void NormalInterpolator::set_fraction(const SFFloat& t)
{
  if (!initialised)
    return;

  float index = get_index(t);
  if (index >= 0. && index <= (float)(keyValue.size/values_per_key - 1))
    post_value_changed(interpolate(index));
}

void NormalInterpolator::render(void)
{
  values_per_key = key.size>0 ? (keyValue.size / key.size) : 0;
  if (keyValue.size != key.size * values_per_key) {
    Error(NULL, "%s: number of key values is not an integer multiple of the numver of key frames", name());
    return;
  }

  if (!initialised) {
    if (keyValue.size > 0)
      value_changed = interpolate(0.);
    initialised = true;
  }
}

}  // namespace xrml
