/* PixelTexture.C: PixelTexture nodes (public source) */

#include "PixelTexture.H"
#include "renderer.H"

namespace xrml {

void PixelTexture::load(void)
{
  if (Map) return; // don't load it twice

  Width = image.width; Height = image.height; Channels = image.num_components;
  Map = new unsigned char[Width * Height * Channels];
  unsigned char *pix = Map;
  for (int i=0; i<Width * Height; i++, pix += Channels) {
    unsigned int pixel = image.pixels[i];
    pix += Channels-1;
    for (int j=Channels-1; j>=0; j--) {
      *pix-- = pixel & 0xff; pixel >>= 8;
    }
    pix++;
  }
}

void PixelTexture::render(void)
{
  // does nothing
}

void PixelTexture::begin_render(void)
{
  //  if (!Map) load();
  world->renderer->begin_PixelTexture(this);
}

void PixelTexture::end_render(void)
{
  world->renderer->end_PixelTexture(this);
}

}  // namespace xrml
