// PixelTexture.H: PixelTexture nodes.

// This file has been generated using nodegen 0.51.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PixelTexture_H_
#define _PixelTexture_H_

#include "xrml.H"
#include "Texture.H"

// utility includes
// end of utility includes

namespace xrml {
#define PixelTextureTypeId 	"PixelTexture"
extern bool IsPixelTexture(SFNode*);

class PixelTexture: public virtual SFNode, public Texture {
private:
  //
  void clone_here(const PixelTexture&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    image_updated = 0x1,
    repeatS_updated = 0x2,
    repeatT_updated = 0x4 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PixelTexture();
  PixelTexture(const PixelTexture&);
  PixelTexture& operator=(const PixelTexture&);
  virtual ~PixelTexture();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFImage          	image;
  //  SFBool           	repeatS;
  //  SFBool           	repeatT;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_image(const SFImage&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_image(const SFImage&);
  bool             	assign_repeatS(const SFBool&);
  bool             	assign_repeatT(const SFBool&);
  
  // update status
  inline bool      	image_is_updated(void) { return (status & image_updated); }
  inline void      	image_clear_update(void) { status &= ~image_updated; }
  inline bool      	repeatS_is_updated(void) { return (status & repeatS_updated); }
  inline void      	repeatS_clear_update(void) { status &= ~repeatS_updated; }
  inline bool      	repeatT_is_updated(void) { return (status & repeatT_updated); }
  inline void      	repeatT_clear_update(void) { status &= ~repeatT_updated; }
  
  // utility members
  void		begin_render(void);
  void		end_render(void);

  void load(void);

protected:
  inline void util_init(void) { }
  inline void util_clone(const PixelTexture& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PixelTexture_H_*/
