/* PointSet.C: PointSet nodes (public source) */

#include "PointSet.H"
#include "renderer.H"
#include "error.H"

namespace xrml {

void PointSet::render(void)
{
  world->renderer->pointSet(this);
}

void PointSet::discretize(void)
{
  if (color) {col = &color->color;} else col = 0;
  if (coord) {co = &coord->point;} else co = 0;
  if (normal) {norm = &normal->vector;} else norm = 0;
  if (texCoord) {texco = &texCoord->point;} else texco = 0;
}

}  // namespace xrml
