// PointSet.H: PointSet nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _PointSet_H_
#define _PointSet_H_

#include "xrml.H"
#include "Geometry.H"
#include "Color.H"
#include "Coordinate.H"
#include "Normal.H"
#include "TextureCoordinate.H"

// utility includes
// end of utility includes

namespace xrml {
#define PointSetTypeId 	"PointSet"
extern bool IsPointSet(SFNode*);

class PointSet: public virtual SFNode, public Geometry {
private:
  //
  void clone_here(const PointSet&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    color_updated = 0x1,
    coord_updated = 0x2,
    normal_updated = 0x4,
    texCoord_updated = 0x8,
    pointsize_updated = 0x10 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_color;
  void 	synchronize_color(void);
  SFNode* 	_coord;
  void 	synchronize_coord(void);
  SFNode* 	_normal;
  void 	synchronize_normal(void);
  SFNode* 	_texCoord;
  void 	synchronize_texCoord(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  PointSet();
  PointSet(const PointSet&);
  PointSet& operator=(const PointSet&);
  virtual ~PointSet();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  Color*           	color;
  Coordinate*      	coord;
  Normal*          	normal;
  TextureCoordinate* 	texCoord;
  SFFloat          	pointsize;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_color(SFNode*);
  void             	set_coord(SFNode*);
  void             	set_normal(SFNode*);
  void             	set_texCoord(SFNode*);
  void             	set_pointsize(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_color(SFNode*);
  bool             	assign_coord(SFNode*);
  bool             	assign_normal(SFNode*);
  bool             	assign_texCoord(SFNode*);
  bool             	assign_pointsize(const SFFloat&);
  
  // update status
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	coord_is_updated(void) { return (status & coord_updated); }
  inline void      	coord_clear_update(void) { status &= ~coord_updated; }
  inline bool      	normal_is_updated(void) { return (status & normal_updated); }
  inline void      	normal_clear_update(void) { status &= ~normal_updated; }
  inline bool      	texCoord_is_updated(void) { return (status & texCoord_updated); }
  inline void      	texCoord_clear_update(void) { status &= ~texCoord_updated; }
  inline bool      	pointsize_is_updated(void) { return (status & pointsize_updated); }
  inline void      	pointsize_clear_update(void) { status &= ~pointsize_updated; }
  
  // utility members
  void discretize(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const PointSet& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_PointSet_H_*/
