// ProximitySensor.H: ProximitySensor nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _ProximitySensor_H_
#define _ProximitySensor_H_

#include "xrml.H"
#include "EnvironmentalSensor.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define ProximitySensorTypeId 	"ProximitySensor"
extern bool IsProximitySensor(SFNode*);

class ProximitySensor: public virtual SFNode, public EnvironmentalSensor, public Children {
private:
  //
  void clone_here(const ProximitySensor&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    center_updated = 0x1,
    size_updated = 0x2,
    enabled_updated = 0x4,
    isActive_updated = 0x8,
    position_changed_updated = 0x10,
    orientation_changed_updated = 0x20,
    enterTime_updated = 0x40,
    exitTime_updated = 0x80 
  };
  
protected:
  // raw eventOut posting:
  void post_isActive(void);
  void post_position_changed(void);
  void post_orientation_changed(void);
  void post_enterTime(void);
  void post_exitTime(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  ProximitySensor();
  ProximitySensor(const ProximitySensor&);
  ProximitySensor& operator=(const ProximitySensor&);
  virtual ~ProximitySensor();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec3f          	center;
  SFVec3f          	size;
  SFBool           	enabled;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_center(const SFVec3f&);
  void             	set_size(const SFVec3f&);
  void             	set_enabled(const SFBool&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_center(const SFVec3f&);
  bool             	assign_size(const SFVec3f&);
  bool             	assign_enabled(const SFBool&);
  
  // eventOuts:
  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  SFVec3f            	position_changed;
  void             	post_position_changed(const SFVec3f& val);
  SFRotation            	orientation_changed;
  void             	post_orientation_changed(const SFRotation& val);
  SFTime            	enterTime;
  void             	post_enterTime(const SFTime& val);
  SFTime            	exitTime;
  void             	post_exitTime(const SFTime& val);
  
  // update status
  inline bool      	center_is_updated(void) { return (status & center_updated); }
  inline void      	center_clear_update(void) { status &= ~center_updated; }
  inline bool      	size_is_updated(void) { return (status & size_updated); }
  inline void      	size_clear_update(void) { status &= ~size_updated; }
  inline bool      	enabled_is_updated(void) { return (status & enabled_updated); }
  inline void      	enabled_clear_update(void) { status &= ~enabled_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  inline bool      	position_changed_is_updated(void) { return (status & position_changed_updated); }
  inline void      	position_changed_clear_update(void) { status &= ~position_changed_updated; }
  inline bool      	orientation_changed_is_updated(void) { return (status & orientation_changed_updated); }
  inline void      	orientation_changed_clear_update(void) { status &= ~orientation_changed_updated; }
  inline bool      	enterTime_is_updated(void) { return (status & enterTime_updated); }
  inline void      	enterTime_clear_update(void) { status &= ~enterTime_updated; }
  inline bool      	exitTime_is_updated(void) { return (status & exitTime_updated); }
  inline void      	exitTime_clear_update(void) { status &= ~exitTime_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const ProximitySensor& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_ProximitySensor_H_*/
