// Shape.H: Shape nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Shape_H_
#define _Shape_H_

#include "xrml.H"
#include "Children.H"
#include "AppearanceBase.H"
#include "Geometry.H"

// utility includes
// end of utility includes

namespace xrml {
#define ShapeTypeId 	"Shape"
extern bool IsShape(SFNode*);

class Shape: public virtual SFNode, public Children {
private:
  //
  void clone_here(const Shape&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    appearance_updated = 0x1,
    geometry_updated = 0x2 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_appearance;
  void 	synchronize_appearance(void);
  SFNode* 	_geometry;
  void 	synchronize_geometry(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Shape();
  Shape(const Shape&);
  Shape& operator=(const Shape&);
  virtual ~Shape();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  AppearanceBase*  	appearance;
  Geometry*        	geometry;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_appearance(SFNode*);
  void             	set_geometry(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_appearance(SFNode*);
  bool             	assign_geometry(SFNode*);
  
  // update status
  inline bool      	appearance_is_updated(void) { return (status & appearance_updated); }
  inline void      	appearance_clear_update(void) { status &= ~appearance_updated; }
  inline bool      	geometry_is_updated(void) { return (status & geometry_updated); }
  inline void      	geometry_clear_update(void) { status &= ~geometry_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Shape& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Shape_H_*/
