// Sound.H: Sound nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _Sound_H_
#define _Sound_H_

#include "xrml.H"
#include "Children.H"
#include "SoundSource.H"

// utility includes
// end of utility includes

namespace xrml {
#define SoundTypeId 	"Sound"
extern bool IsSound(SFNode*);

class Sound: public virtual SFNode, public Children {
private:
  //
  void clone_here(const Sound&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    direction_updated = 0x1,
    intensity_updated = 0x2,
    location_updated = 0x4,
    maxBack_updated = 0x8,
    maxFront_updated = 0x10,
    minBack_updated = 0x20,
    minFront_updated = 0x40,
    priority_updated = 0x80,
    source_updated = 0x100,
    spatialize_updated = 0x200 
  };
  
protected:
  // raw children nodes (can be PROTO) + synchronize methods:
  SFNode* 	_source;
  void 	synchronize_source(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  Sound();
  Sound(const Sound&);
  Sound& operator=(const Sound&);
  virtual ~Sound();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFVec3f          	direction;
  SFFloat          	intensity;
  SFVec3f          	location;
  SFFloat          	maxBack;
  SFFloat          	maxFront;
  SFFloat          	minBack;
  SFFloat          	minFront;
  SFFloat          	priority;
  SoundSource*     	source;
  SFBool           	spatialize;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_direction(const SFVec3f&);
  void             	set_intensity(const SFFloat&);
  void             	set_location(const SFVec3f&);
  void             	set_maxBack(const SFFloat&);
  void             	set_maxFront(const SFFloat&);
  void             	set_minBack(const SFFloat&);
  void             	set_minFront(const SFFloat&);
  void             	set_priority(const SFFloat&);
  void             	set_source(SFNode*);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_direction(const SFVec3f&);
  bool             	assign_intensity(const SFFloat&);
  bool             	assign_location(const SFVec3f&);
  bool             	assign_maxBack(const SFFloat&);
  bool             	assign_maxFront(const SFFloat&);
  bool             	assign_minBack(const SFFloat&);
  bool             	assign_minFront(const SFFloat&);
  bool             	assign_priority(const SFFloat&);
  bool             	assign_source(SFNode*);
  bool             	assign_spatialize(const SFBool&);
  
  // update status
  inline bool      	direction_is_updated(void) { return (status & direction_updated); }
  inline void      	direction_clear_update(void) { status &= ~direction_updated; }
  inline bool      	intensity_is_updated(void) { return (status & intensity_updated); }
  inline void      	intensity_clear_update(void) { status &= ~intensity_updated; }
  inline bool      	location_is_updated(void) { return (status & location_updated); }
  inline void      	location_clear_update(void) { status &= ~location_updated; }
  inline bool      	maxBack_is_updated(void) { return (status & maxBack_updated); }
  inline void      	maxBack_clear_update(void) { status &= ~maxBack_updated; }
  inline bool      	maxFront_is_updated(void) { return (status & maxFront_updated); }
  inline void      	maxFront_clear_update(void) { status &= ~maxFront_updated; }
  inline bool      	minBack_is_updated(void) { return (status & minBack_updated); }
  inline void      	minBack_clear_update(void) { status &= ~minBack_updated; }
  inline bool      	minFront_is_updated(void) { return (status & minFront_updated); }
  inline void      	minFront_clear_update(void) { status &= ~minFront_updated; }
  inline bool      	priority_is_updated(void) { return (status & priority_updated); }
  inline void      	priority_clear_update(void) { status &= ~priority_updated; }
  inline bool      	source_is_updated(void) { return (status & source_updated); }
  inline void      	source_clear_update(void) { status &= ~source_updated; }
  inline bool      	spatialize_is_updated(void) { return (status & spatialize_updated); }
  inline void      	spatialize_clear_update(void) { status &= ~spatialize_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const Sound& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_Sound_H_*/
