// SphereSensor.H: SphereSensor nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _SphereSensor_H_
#define _SphereSensor_H_

#include "xrml.H"
#include "DragSensor.H"
#include "Children.H"

// utility includes
// end of utility includes

namespace xrml {
#define SphereSensorTypeId 	"SphereSensor"
extern bool IsSphereSensor(SFNode*);

class SphereSensor: public virtual SFNode, public DragSensor, public Children {
private:
  //
  void clone_here(const SphereSensor&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    autoOffset_updated = 0x1,
    enabled_updated = 0x2,
    offset_updated = 0x4,
    isActive_updated = 0x8,
    rotation_changed_updated = 0x10,
    trackPoint_changed_updated = 0x20 
  };
  
protected:
  // raw eventOut posting:
  void post_isActive(void);
  void post_rotation_changed(void);
  void post_trackPoint_changed(void);

public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  SphereSensor();
  SphereSensor(const SphereSensor&);
  SphereSensor& operator=(const SphereSensor&);
  virtual ~SphereSensor();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  SFBool           	autoOffset;
  SFBool           	enabled;
  SFRotation       	offset;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_autoOffset(const SFBool&);
  void             	set_enabled(const SFBool&);
  void             	set_offset(const SFRotation&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_autoOffset(const SFBool&);
  bool             	assign_enabled(const SFBool&);
  bool             	assign_offset(const SFRotation&);
  
  // eventOuts:
  SFBool            	isActive;
  void             	post_isActive(const SFBool& val);
  SFRotation            	rotation_changed;
  void             	post_rotation_changed(const SFRotation& val);
  //  SFVec3f            	trackPoint_changed;
  void             	post_trackPoint_changed(const SFVec3f& val);
  
  // update status
  inline bool      	autoOffset_is_updated(void) { return (status & autoOffset_updated); }
  inline void      	autoOffset_clear_update(void) { status &= ~autoOffset_updated; }
  inline bool      	enabled_is_updated(void) { return (status & enabled_updated); }
  inline void      	enabled_clear_update(void) { status &= ~enabled_updated; }
  inline bool      	offset_is_updated(void) { return (status & offset_updated); }
  inline void      	offset_clear_update(void) { status &= ~offset_updated; }
  inline bool      	isActive_is_updated(void) { return (status & isActive_updated); }
  inline void      	isActive_clear_update(void) { status &= ~isActive_updated; }
  inline bool      	rotation_changed_is_updated(void) { return (status & rotation_changed_updated); }
  inline void      	rotation_changed_clear_update(void) { status &= ~rotation_changed_updated; }
  inline bool      	trackPoint_changed_is_updated(void) { return (status & trackPoint_changed_updated); }
  inline void      	trackPoint_changed_clear_update(void) { status &= ~trackPoint_changed_updated; }
  
  // utility members
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const SphereSensor& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_SphereSensor_H_*/
