// SpotLight.H: SpotLight nodes.

// This file has been generated using nodegen 0.5a.
// Restrict manual editing to the sections delimited by
// . the comments "utility includes" and "end of utility includes"
// . the comments "utility members" and "end of utility members"

#ifndef _SpotLight_H_
#define _SpotLight_H_

#include "xrml.H"
#include "Children.H"
#include "LightSource.H"

// utility includes
// end of utility includes

namespace xrml {
#define SpotLightTypeId 	"SpotLight"
extern bool IsSpotLight(SFNode*);

class SpotLight: public virtual SFNode, public Children, public LightSource {
private:
  //
  void clone_here(const SpotLight&);
  void destruct(void);
  
  // field/eventOut update status bits
  // Use xxx_is_updated() and xxx_clear_update() to inspect/reset.
  enum status_bits {
    ambientIntensity_updated = 0x1,
    attenuation_updated = 0x2,
    beamWidth_updated = 0x4,
    color_updated = 0x8,
    cutOffAngle_updated = 0x10,
    direction_updated = 0x20,
    intensity_updated = 0x40,
    location_updated = 0x80,
    on_updated = 0x100,
    radius_updated = 0x200 
  };
  
public:
  //
  int major_version(void), minor_version(void);
  bool is_leaf_class(void);
  
  SpotLight();
  SpotLight(const SpotLight&);
  SpotLight& operator=(const SpotLight&);
  virtual ~SpotLight();
  
  //
  SFNode*          	instantiate(Proto * =0);
  void             	render(void);
  
  // state values:
  // Do not assign directly unless you know very well what you are doing.
  //  SFFloat          	ambientIntensity;
  SFVec3f          	attenuation;
  SFFloat          	beamWidth;
  //  SFColor          	color;
  SFFloat          	cutOffAngle;
  SFVec3f          	direction;
  //  SFFloat          	intensity;
  SFVec3f          	location;
  //  SFBool           	on;
  SFFloat          	radius;
  
  // set_<exposedField> eventIns: with forwarding and eventOut generation
  void             	set_ambientIntensity(const SFFloat&);
  void             	set_attenuation(const SFVec3f&);
  void             	set_beamWidth(const SFFloat&);
  void             	set_color(const SFColor&);
  void             	set_cutOffAngle(const SFFloat&);
  void             	set_direction(const SFVec3f&);
  void             	set_intensity(const SFFloat&);
  void             	set_location(const SFVec3f&);
  void             	set_on(const SFBool&);
  void             	set_radius(const SFFloat&);
  
  // field assignement: no forwarding or eventOut generation!
  bool             	assign_ambientIntensity(const SFFloat&);
  bool             	assign_attenuation(const SFVec3f&);
  bool             	assign_beamWidth(const SFFloat&);
  bool             	assign_color(const SFColor&);
  bool             	assign_cutOffAngle(const SFFloat&);
  bool             	assign_direction(const SFVec3f&);
  bool             	assign_intensity(const SFFloat&);
  bool             	assign_location(const SFVec3f&);
  bool             	assign_on(const SFBool&);
  bool             	assign_radius(const SFFloat&);
  
  // update status
  inline bool      	ambientIntensity_is_updated(void) { return (status & ambientIntensity_updated); }
  inline void      	ambientIntensity_clear_update(void) { status &= ~ambientIntensity_updated; }
  inline bool      	attenuation_is_updated(void) { return (status & attenuation_updated); }
  inline void      	attenuation_clear_update(void) { status &= ~attenuation_updated; }
  inline bool      	beamWidth_is_updated(void) { return (status & beamWidth_updated); }
  inline void      	beamWidth_clear_update(void) { status &= ~beamWidth_updated; }
  inline bool      	color_is_updated(void) { return (status & color_updated); }
  inline void      	color_clear_update(void) { status &= ~color_updated; }
  inline bool      	cutOffAngle_is_updated(void) { return (status & cutOffAngle_updated); }
  inline void      	cutOffAngle_clear_update(void) { status &= ~cutOffAngle_updated; }
  inline bool      	direction_is_updated(void) { return (status & direction_updated); }
  inline void      	direction_clear_update(void) { status &= ~direction_updated; }
  inline bool      	intensity_is_updated(void) { return (status & intensity_updated); }
  inline void      	intensity_clear_update(void) { status &= ~intensity_updated; }
  inline bool      	location_is_updated(void) { return (status & location_updated); }
  inline void      	location_clear_update(void) { status &= ~location_updated; }
  inline bool      	on_is_updated(void) { return (status & on_updated); }
  inline void      	on_clear_update(void) { status &= ~on_updated; }
  inline bool      	radius_is_updated(void) { return (status & radius_updated); }
  inline void      	radius_clear_update(void) { status &= ~radius_updated; }
  
  // utility members
  void begin_render(void);
  void end_render(void);
  
protected:
  inline void util_init(void) { }
  inline void util_clone(const SpotLight& src) { }
  inline void util_destruct(void) { }
};

// end of utility members
} // namespace xrml
#endif /*_SpotLight_H_*/
