/* TextureTransform.C: TextureTransform nodes (public source) */

#include "TextureTransform.H"
#include "renderer.H"

namespace xrml {

void TextureTransform::work_out(void)
{
  xf = xf.translation(Vec3(translation.s, translation.t, 0.)) *
    xf.translation(Vec3(center.s, center.t, 0.)) *
    xf.rotation(Vec4(0.,0.,1.,rotation)) *
    xf.scaling(Vec3(scale.s, scale.t, 1.)) *
    xf.translation(-Vec3(center.s, center.t, 0.));

  xf_vec = xf.rotation(Vec4(0.,0.,1.,rotation)) *
    xf.scaling(Vec3(scale.s, scale.t, 1.));
}

void TextureTransform::work_out_inverse(void)
{
  inverse_xf = xf.translation(Vec3(center.s, center.t, 0.)) *
    xf.scaling(Vec3(1./scale.s, 1./scale.t, 1.)) *
    xf.rotation(Vec4(0.,0.,1.,-rotation)) *
    xf.translation(-Vec3(center.s, center.t, 0.)) *
    xf.translation(-Vec3(translation.s, translation.t, 0.));

  inverse_xf_vec = xf.scaling(Vec3(1./scale.s, 1./scale.t, 1.)) *
    xf.rotation(Vec4(0.,0.,1.,-rotation));
}

void TextureTransform::render(void)
{
  work_out();
  work_out_inverse();
}

void TextureTransform::begin_render(void)
{
  render();
  world->renderer->begin_TextureTransform(this);
}

void TextureTransform::end_render(void)
{
  world->renderer->end_TextureTransform(this);
}

}  // namespace xrml
